/*+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-

  Name   : AppTimer

  Desc   : Provide convenient elapsed time features.

  Comment: uses O/S millis() to get current time.
           handles rollover correctly.
            
  Example 1 : 

        CAppTimer pubTime(5000);
        loop ()
        {
          if ( pubTime.Timeout() )
            {
                pubTime.Start(5000);
                // do something useful...;
            }
          ...
          // do other stuff 
        }
      
  Example 2 : 

        CAppTimer elapsedTime.Start(0);                // sets now as a reference
        -or-
        CAppTimer elapsedTime;                          // same as elapsedTime.Start(0);
        loop ()
        {
            .
            . do a bunch of stuff.
            .
            Serial.println("%lu ms have elapsed", elapsedTime.ElapsedTime());       // Determine elapsed time
        }

+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/
#ifndef _APPTIMER_H
#define _APPTIMER_H

#include "ClearCore.h"

class CAppTimer 
{
public:
    CAppTimer();
    CAppTimer(uint32_t StartTimeMS);
    ~CAppTimer();

    void    Start(uint32_t StartTimeMS);
    bool    Timeout(void);
    bool    IsActive(void) { return !Timeout(); };
    void    Stop(void);
    uint32_t ElapsedMillis();

private:
    uint32_t    startTime;
    uint32_t    Delay;
    bool        fActive;
};

//
// same but using Microseconds
//
class CAppTimerMicros 
{
public:
    CAppTimerMicros();
    CAppTimerMicros(uint32_t StartTimeUS);
    ~CAppTimerMicros();

    void    StartMicros(uint32_t StartTimeUS);
    bool    Timeout(void);
    bool    IsActive(void) { return !Timeout(); };
    void    Stop(void);
    uint32_t ElapsedMicros();

private:
    uint32_t    startTime;
    uint32_t    Delay;
    bool        fActive;
};
#endif  // _APPTIMER_H
